﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Low_Memory_Candy
{
    class RainCandySystem
    {
        const int ranSelector = int.MaxValue;

        Candy[] candys = new Candy[100];
        Texture2D[] textures;

        Random ran = new Random(Guid.NewGuid().GetHashCode());

        public Player p;

        public RainCandySystem(Texture2D[] candys, bool create = true, int howMany = -1)
        {
            this.textures = candys;
            if (howMany > 0) this.candys = new Candy[howMany];
            if (create) init();
        }

        public void init()
        {
            for (int i = 0; i < candys.Length; i++)
            {
                newCandy(i, ran.Next(textures.Length - 1));
            }
        }

        public void update(Player player)
        {
            p = player;

            for (int i = 0; i < candys.Length; i++)
            {
                candys[i].update();

                if (candys[i].pos.Y - candys[i].tex.Height > Game.screenHeight) 
                {
                    newCandy(i, ran.Next(textures.Length - 1));
                }
            }

            int[] nc = getNearbyCandys();
            for (int i = 0; i < nc.Length; i++)
            {
                if (!p.gameOver && p.pos.Y + p.tex.Height > candys[nc[i]].pos.Y && p.pos.Y < candys[nc[i]].pos.Y + candys[nc[i]].tex.Height &&
                    p.pos.X + p.tex.Width > candys[nc[i]].pos.X && p.pos.X < candys[nc[i]].pos.X + candys[nc[i]].tex.Width)
                {
                    if (candys[nc[i]].isPowerUp) p.hitPowerUp();
                    else p.hitCandy();
                    newCandy(nc[i], ran.Next(textures.Length - 1));
                }
            }
        }

        void newCandy(int where, int texture)
        {
            bool special = (ran.Next(360) == 19);
            if (special) texture = textures.Length - 1;

            // I am sorry candy, you are adopted by some Texture2D.
            candys[where] = new Candy(
                new Vector2(ran.Next(1 + Game.screenWidth - textures[texture].Width), -ran.Next(1 + textures[texture].Height, Game.screenHeight * 2)),
                textures[texture], ran.Next(10, 16) / 10, ran.Next(28, 40) / 10, ran.Next(366), ran.Next(20, 50) / 10);

            if (special) candys[where].isPowerUp = true;

            ran = new Random(ran.Next(ranSelector));
        }

        public void draw(SpriteBatch sb)
        {
            foreach (Candy c in candys) c.draw(sb);
        }

        public int[] getNearbyCandys(int range = 80)
        {
            Vector2 min = new Vector2(p.pos.X - range, p.pos.Y - range);
            Vector2 max = new Vector2(p.pos.X + range, p.pos.Y + range);
            int[] toReturn = new int[candys.Length];
            int a = 0;

            for (int i = 0; i < candys.Length; i++)
            {
                if (candys[i].pos.Y > min.Y && candys[i].pos.X > min.X && candys[i].pos.X < max.X && candys[i].pos.Y < max.Y)
                {
                    toReturn[a] = i;
                    a++;
                }
            }

            Array.Resize(ref toReturn, a); // A gets plussed.
            return toReturn;
        }
    }
}
